//
//  AppDelegate.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 13/06/2022.
//

import UIKit
import FirebaseCore
import FirebaseMessaging

@main
class AppDelegate: UIResponder, UIApplicationDelegate, UNUserNotificationCenterDelegate, MessagingDelegate {

    var pendingPush = false

    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        // Override point for customization after application launch.

        InweboService.sharedInstance.initInwebo(macAccess: "f9a1f283a8af89bec62731ccdaec758d", hostVersion: "demo_app_ios")
        FirebaseApp.configure()
        Messaging.messaging().delegate = self
        
        if let _ = launchOptions?[UIApplication.LaunchOptionsKey.remoteNotification] as? [String: AnyObject] {
            pendingPush = true
        }

        UNUserNotificationCenter.current().delegate = self

        return true
    }
    
    static func shared() -> AppDelegate? {
        if let appDelegate = UIApplication.shared.delegate as? AppDelegate {
            return appDelegate
        }
        return nil
    }

    // MARK: UISceneSession Lifecycle

    func application(_ application: UIApplication, configurationForConnecting connectingSceneSession: UISceneSession, options: UIScene.ConnectionOptions) -> UISceneConfiguration {
        // Called when a new scene session is being created.
        // Use this method to select a configuration to create the new scene with.
        return UISceneConfiguration(name: "Default Configuration", sessionRole: connectingSceneSession.role)
    }

    func application(_ application: UIApplication, didDiscardSceneSessions sceneSessions: Set<UISceneSession>) {
        // Called when the user discards a scene session.
        // If any sessions were discarded while the application was not running, this will be called shortly after application:didFinishLaunchingWithOptions.
        // Use this method to release any resources that were specific to the discarded scenes, as they will not return.
    }

    // MARK: - Navigation
    func startDemo(from: UIViewController) {
        if let window = from.view.window {
            let viewController = UIStoryboard(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "Start")
            window.rootViewController = viewController
        }
    }

    // MARK: - Notifications

    func userNotificationCenter(_ center: UNUserNotificationCenter, willPresent notification: UNNotification, withCompletionHandler completionHandler: @escaping (UNNotificationPresentationOptions) -> Void) {
        let userInfo = notification.request.content.userInfo

        print("notification received: \(userInfo)")
        
        completionHandler([[.alert, .sound]])
    }

    
    func application(_ application: UIApplication, didReceiveRemoteNotification userInfo: [AnyHashable : Any]) async -> UIBackgroundFetchResult {
        if let action = userInfo["action"] as? String,
           action == "authenticate" {
            let content = UNMutableNotificationContent()
            content.title = "Auhentication request"
            if let service = userInfo["serviceName"] as? String {
                content.body = "You received an authentication request from \(service)"
            } else {
                content.body = "You received an authentication request"
            }
            let request = UNNotificationRequest(identifier: UUID().uuidString, content: content, trigger: nil)

            UNUserNotificationCenter.current().add(request) { error in
                if let error = error {
                    print("notification error \(error)")
                }
            }
        }
        
        return UIBackgroundFetchResult.newData
    }
    
    func userNotificationCenter(_ center: UNUserNotificationCenter, didReceive response: UNNotificationResponse, withCompletionHandler completionHandler: @escaping () -> Void) {
        NotificationCenter.default.post(name: Notification.Name("notification"), object: nil)
    }

    private var registerPushCallback: ((_ token: String) -> Void)?
    
    func registerNotification(callback: @escaping (_ token: String) -> Void) {

        let authOptions: UNAuthorizationOptions = [.alert, .badge, .sound]
        UNUserNotificationCenter.current().requestAuthorization(
            options: authOptions,
            completionHandler: { _, _ in }
        )
        
        self.registerPushCallback = callback
        UIApplication.shared.registerForRemoteNotifications()
    }

    func application(_ application: UIApplication,
                     didRegisterForRemoteNotificationsWithDeviceToken deviceToken: Data) {
        Messaging.messaging().apnsToken = deviceToken
        if let token = Messaging.messaging().fcmToken, let callback = registerPushCallback {
            callback(token)
        }
    }

    func messaging(_ messaging: Messaging, didReceiveRegistrationToken fcmToken: String?) {
      
        if let token = fcmToken, let callback = registerPushCallback {
            callback(token)
        }
    }

}

